﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/ec2/EC2_EXPORTS.h>
#include <aws/ec2/model/ResponseMetadata.h>
#include <aws/ec2/model/UnsuccessfulItem.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace EC2 {
namespace Model {
class ModifyHostsResponse {
 public:
  AWS_EC2_API ModifyHostsResponse() = default;
  AWS_EC2_API ModifyHostsResponse(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_EC2_API ModifyHostsResponse& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>The IDs of the Dedicated Hosts that were successfully modified.</p>
   */
  inline const Aws::Vector<Aws::String>& GetSuccessful() const { return m_successful; }
  template <typename SuccessfulT = Aws::Vector<Aws::String>>
  void SetSuccessful(SuccessfulT&& value) {
    m_successfulHasBeenSet = true;
    m_successful = std::forward<SuccessfulT>(value);
  }
  template <typename SuccessfulT = Aws::Vector<Aws::String>>
  ModifyHostsResponse& WithSuccessful(SuccessfulT&& value) {
    SetSuccessful(std::forward<SuccessfulT>(value));
    return *this;
  }
  template <typename SuccessfulT = Aws::String>
  ModifyHostsResponse& AddSuccessful(SuccessfulT&& value) {
    m_successfulHasBeenSet = true;
    m_successful.emplace_back(std::forward<SuccessfulT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The IDs of the Dedicated Hosts that could not be modified. Check whether the
   * setting you requested can be used.</p>
   */
  inline const Aws::Vector<UnsuccessfulItem>& GetUnsuccessful() const { return m_unsuccessful; }
  template <typename UnsuccessfulT = Aws::Vector<UnsuccessfulItem>>
  void SetUnsuccessful(UnsuccessfulT&& value) {
    m_unsuccessfulHasBeenSet = true;
    m_unsuccessful = std::forward<UnsuccessfulT>(value);
  }
  template <typename UnsuccessfulT = Aws::Vector<UnsuccessfulItem>>
  ModifyHostsResponse& WithUnsuccessful(UnsuccessfulT&& value) {
    SetUnsuccessful(std::forward<UnsuccessfulT>(value));
    return *this;
  }
  template <typename UnsuccessfulT = UnsuccessfulItem>
  ModifyHostsResponse& AddUnsuccessful(UnsuccessfulT&& value) {
    m_unsuccessfulHasBeenSet = true;
    m_unsuccessful.emplace_back(std::forward<UnsuccessfulT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  ModifyHostsResponse& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Aws::String> m_successful;
  bool m_successfulHasBeenSet = false;

  Aws::Vector<UnsuccessfulItem> m_unsuccessful;
  bool m_unsuccessfulHasBeenSet = false;

  ResponseMetadata m_responseMetadata;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace EC2
}  // namespace Aws
